/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.nickhider;

import club.sk1er.nickhider.CommandNickHider;
import club.sk1er.nickhider.NickHiderConfig;
import club.sk1er.nickhider.mixins.MixinsGuiScreenBook;
import club.sk1er.nickhider.utils.Multithreading;
import club.sk1er.nickhider.utils.Sk1erMod;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.command.ICommand;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.io.FileUtils;

@Mod(modid="nick_hider", version="5.2", name="Sk1er Nick Hider", acceptedMinecraftVersions="[1.8.9]")
public class NickHider {
    public static final String MOD_ID = "nick_hider";
    public static final String MOD_NAME = "Sk1er Nick Hider";
    public static final String VERSION = "5.2";
    @Mod.Instance
    public static NickHider INSTANCE;
    private final Pattern newNick = Pattern.compile("We've generated a random username for you: \\s*(?<nick>\\S+)");
    private final List<Nick> nicks = new ArrayList<Nick>();
    private File suggestedConfigurationFile;
    private HashMap<String, String> cache = new HashMap();
    private Set<String> usedNicks = new HashSet<String>();
    private Sk1erMod sk1erMod;
    private NickHiderConfig config;
    private boolean forceDown = false;
    private boolean extendedUse = false;
    private String override = null;
    private List<String> namesDatabase = new ArrayList<String>();
    private ResourceLocation playerSkin;
    private boolean startedLoadingSkin = false;
    private String playerRealSkinType = "default";
    private ResourceLocation playerCape;

    public NickHider() {
        INSTANCE = this;
    }

    public static void main(String[] args) {
        System.out.println("*".hashCode());
    }

    public Set<String> getUsedNicks() {
        return this.usedNicks;
    }

    public String getPseudo_key() {
        return this.config.getPseudo_key();
    }

    public void setPseudo_key(String pseudo_key) {
        this.config.setPseudo_key(pseudo_key);
    }

    public String getPseudo(String input) {
        int size;
        int i = input.hashCode() + this.getPseudo_key().hashCode();
        if (i < 0) {
            i = -i;
        }
        if ((size = this.namesDatabase.size()) == 0) {
            return "Player-error";
        }
        return this.config.getPrefix() + this.namesDatabase.get(i % size) + this.config.getSuffix() + (this.config.getPrefix().equalsIgnoreCase("Player-") ? "" : this.getStar());
    }

    private String getStar() {
        String s = "*";
        int i = s.hashCode();
        if (s.isEmpty() || i != 42) {
            throw new IllegalStateException("Potential illegal nickhider modification found. If you did NOT edit Nick Hider, contact Sk1er (" + s + ")");
        }
        return s;
    }

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        this.sk1erMod = new Sk1erMod(MOD_ID, VERSION, "Nick Hider", object -> {
            if (!object.optBoolean("enabled")) {
                this.forceDown = true;
            }
            if (object.optBoolean("extended")) {
                this.extendedUse = true;
            }
        });
        Multithreading.runAsync(() -> {
            String s = this.sk1erMod.rawWithAgent("https://sk1er.club/words.txt?uuid=" + Minecraft.func_71410_x().func_110432_I().func_148256_e().getId());
            this.namesDatabase.addAll(Arrays.asList(s.split("\n")));
        });
        this.sk1erMod.checkStatus();
        this.suggestedConfigurationFile = event.getSuggestedConfigurationFile();
        if (this.suggestedConfigurationFile.exists()) {
            try {
                String s = FileUtils.readFileToString((File)event.getSuggestedConfigurationFile());
                this.config = (NickHiderConfig)new Gson().fromJson(s, NickHiderConfig.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.config == null) {
            this.config = new NickHiderConfig();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandNickHider());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            String s = new Gson().toJson((Object)this.config);
            try {
                FileUtils.write((File)this.suggestedConfigurationFile, (CharSequence)s);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
    }

    public boolean isExtendedUse() {
        return this.extendedUse;
    }

    @SubscribeEvent
    public void bookCheck(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen == null) {
            return;
        }
        if (currentScreen instanceof GuiScreenBook) {
            NBTTagList bookPages = ((MixinsGuiScreenBook)currentScreen).getBookPages();
            int currPage = ((MixinsGuiScreenBook)currentScreen).getCurrPage();
            if (currPage < bookPages.func_74745_c()) {
                try {
                    String textWithoutFormattingCodes = EnumChatFormatting.func_110646_a((String)IChatComponent.Serializer.func_150699_a((String)bookPages.func_150307_f(currPage)).func_150260_c().replace("\n", " "));
                    Matcher matcher = this.newNick.matcher(textWithoutFormattingCodes);
                    if (matcher.find()) {
                        String nick = matcher.group("nick");
                        this.remap(nick, this.override == null ? Minecraft.func_71410_x().func_110432_I().func_148256_e().getName() : this.override);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setOwnName(String name) {
        this.override = name;
        String name1 = Minecraft.func_71410_x().func_110432_I().func_148256_e().getName();
        this.usedNicks.remove(name1.toLowerCase());
        this.nicks.removeIf(nick -> nick.oldName.equalsIgnoreCase(name1));
        this.remap(name1, name);
    }

    public List<Nick> getNicks() {
        return this.nicks;
    }

    public HashMap<String, String> getCache() {
        return this.cache;
    }

    @SubscribeEvent
    public void profileCheck(TickEvent.RenderTickEvent event) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer == null) {
            return;
        }
        NetHandlerPlayClient sendQueue = thePlayer.field_71174_a;
        if (sendQueue == null) {
            return;
        }
        for (NetworkPlayerInfo networkPlayerInfo : sendQueue.func_175106_d()) {
            GameProfile gameProfile = networkPlayerInfo.func_178845_a();
            if (gameProfile.getId() != null && gameProfile.getId().equals(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId())) {
                if (gameProfile.getName().equalsIgnoreCase(Minecraft.func_71410_x().func_110432_I().func_148256_e().getName())) continue;
                this.remap(gameProfile.getName(), this.override == null ? Minecraft.func_71410_x().func_110432_I().func_148256_e().getName() : this.override);
                continue;
            }
            if (!this.config.isHideOtherNames()) continue;
            this.remap(gameProfile.getName(), this.getPseudo(gameProfile.getName()));
        }
    }

    public boolean isHideSkins() {
        return this.config.isHideSkins();
    }

    public void setHideSkins(boolean hideSkins) {
        this.config.setHideSkins(hideSkins);
    }

    public void reset() {
        this.nicks.clear();
        this.cache.clear();
        this.usedNicks.clear();
    }

    public void remap(String key, String newKey) {
        if (this.usedNicks.contains(key = key.toLowerCase())) {
            return;
        }
        if (key.isEmpty() || key.contains(" ")) {
            return;
        }
        this.usedNicks.add(key);
        Nick nick = new Nick(Pattern.compile(key.toLowerCase(), 2), key, key.length() > 2 ? newKey : key);
        this.nicks.add(nick);
        Comparator<Nick> c = Comparator.comparingInt(o -> o.oldName.length());
        this.nicks.sort(c.reversed());
        this.cache.clear();
    }

    public String apply(String input) {
        if (this.config == null) {
            this.config = new NickHiderConfig();
        }
        if (!this.config.isMasterEnabled()) {
            return input;
        }
        if (this.forceDown) {
            return input;
        }
        if (!this.config.isHideNames()) {
            return input;
        }
        if (this.cache.size() > 5000) {
            this.cache.clear();
        }
        return this.cache.computeIfAbsent(input, s -> {
            String base = input;
            for (Nick nick : this.nicks) {
                base = nick.pattern.matcher(base).replaceAll(nick.newName);
            }
            return base;
        });
    }

    public boolean isHideNames() {
        return this.config.isHideNames();
    }

    public boolean isSelfOnly() {
        return this.config.isHideOtherNames();
    }

    public void toggleHideNames() {
        this.config.setHideNames(!this.config.isHideNames());
        this.reset();
    }

    public void toggleSelf() {
        this.config.setHideOtherNames(!this.config.isHideOtherNames());
        this.reset();
    }

    public String out(String chat) {
        if (!this.isHideNames()) {
            return chat;
        }
        for (Nick nick : this.nicks) {
            chat = Pattern.compile(nick.newName, 2).matcher(chat).replaceAll(nick.oldName);
        }
        return chat;
    }

    public String[] tabComplete(String[] in, String soFar) {
        if (!this.isHideNames()) {
            return in;
        }
        String[] split = soFar.split(" ");
        String tmp = split[split.length - 1];
        ArrayList<String> tmp1 = new ArrayList<String>();
        for (int i = 0; i < in.length; ++i) {
            in[i] = this.apply(in[i]);
        }
        for (Nick nick : this.nicks) {
            if (!nick.newName.toLowerCase().startsWith(tmp.toLowerCase())) continue;
            tmp1.add(nick.newName);
        }
        HashSet strings = Sets.newHashSet((Object[])in);
        strings.addAll(tmp1);
        return strings.toArray(new String[0]);
    }

    public NickHiderConfig getConfig() {
        return this.config;
    }

    public String getPlayerRealSkinType() {
        return this.playerRealSkinType;
    }

    public ResourceLocation getPlayerCape() {
        return this.playerCape;
    }

    public ResourceLocation getPlayerSkin() {
        if (this.playerSkin == null && !this.startedLoadingSkin) {
            this.startedLoadingSkin = true;
            Minecraft.func_71410_x().func_152342_ad().func_152790_a(Minecraft.func_71410_x().func_110432_I().func_148256_e(), (p_180521_1_, location, profileTexture) -> {
                if (p_180521_1_ == MinecraftProfileTexture.Type.SKIN) {
                    this.playerSkin = location;
                    this.playerRealSkinType = profileTexture.getMetadata("model");
                    if (this.playerRealSkinType == null) {
                        this.playerRealSkinType = "default";
                    }
                } else if (p_180521_1_ == MinecraftProfileTexture.Type.CAPE) {
                    this.playerCape = location;
                }
            }, true);
        }
        return this.playerSkin;
    }

    class Nick {
        public Pattern pattern;
        public String oldName;
        public String newName;

        public Nick(Pattern pattern, String oldName, String newName) {
            this.pattern = pattern;
            this.oldName = oldName;
            this.newName = newName;
        }
    }
}

